/*
 * mgt_demo.cpp
 *
 *  all right reserved by Xinhuan Intelligence co., ltd
 *  contact us at http://www.lightlpr.com
 *
 *  biz@lightlpr.com
 *
 */

#include <thread>
#include <iostream>
#include <fstream>
#include <stdio.h>
#include <stdlib.h>
#include <chrono>
#include <string.h>

#include "lpr_comm.h"
#include "dev_client_api.h"

int main(int argc, char **argv)
{
	if (argc < 2)
	{
		printf("usage: mgt_demo -reboot [device ip] for reboot device \n"
			   "mgt_demo -deviceinfo [device_ip] for basic device info \n"
			   "mgt_demo -alarmout [device_ip] [line] [duration] trigger alarmout with line and milliseconds duration parameter \n"
			   "mgt_demo -query_alarmout [device_ip] [line] query alarm out line status \n"
			   "mgt_demo -snapshot [device_ip] take a snapshot for device \n"
			   "mgt_demo -write_uart [device_ip] [alias] [data] write data to UART with ID, for E5 product, the ID is 2 for 485-1 \n"
			   "mgt_demo -set_time [device_ip] [unix time epoch] set camera's time \n"
			   "mgt_demo -append_bwlist [device_ip] \n"
			   "mgt_demo -remove_bwlist [device_ip] \n"
			   "mgt_demo -clean_bwlist [device_ip]  \n"
			   "mgt_demo -query_bwlist [device_ip]  \n"
				);
	}

	const char *device_ip = argv[2]; 
	const char * cmd = argv[1];
	if (argc == 3 && strcmp(cmd, "-reboot") == 0)
	{
		reboot_device(device_ip);
		printf("device will reboot in 30 seconds!\n");
	} 

	if (argc == 3 && strcmp(cmd, "-deviceinfo") == 0)
	{
		DeviceInfo deviceInfo;
		if (get_device_info(device_ip, &deviceInfo) == NO_EXCEPTION)
		{
			printf("device name: %s, IP: %s, firmware: %s, version: %s, minVersion: %d, productNo: %s, startup: %ld\n",
				   deviceInfo.deviceName,
				   deviceInfo.ip,
				   deviceInfo.firmware,
				   deviceInfo.version,
				   deviceInfo.minVersion,
				   deviceInfo.productNo,
				   deviceInfo.startup);
		}
		else
		{
			printf("get device info error\n");
		}
	}

	if (argc == 5 && strcmp(cmd, "-alarmout") == 0)
	{
		int line = atoi(argv[3]);
		int duration = atoi(argv[4]);
		trigger_alarmout(device_ip, line, duration);
	}

	if (argc == 4 && strcmp(cmd, "-query_alarmout") == 0)
	{
		int line = atoi(argv[3]);
		int status = -1;
		int ret = query_alarm(device_ip, line, &status);
		if (ret == NO_EXCEPTION)
		{
			printf("query alarm out line status: %d \n", status);
		} 
	}

	if (argc == 3 && strcmp(cmd, "-snapshot") == 0)
	{
		take_snapshot(device_ip);
	}

	if (argc == 5 && strcmp(cmd, "-write_uart") == 0)
	{
		char * alias = argv[3];
		char * data = argv[4];
		int len = strlen(data);
		write_uart(device_ip, alias, data, len);
	}

	if (argc == 4 && strcmp(cmd, "-set_time") == 0)
	{
		int epoch = atoi(argv[3]);
		int r = set_time(device_ip, epoch);
		printf("execute set_time result has %d exception\n", r);
	}

	if (argc == 3 && strcmp(cmd, "-append_bwlist") == 0)
	{
		sBlackWhiteEntry entries[1];
		entries[0].type = 0;
		char * plateNo = "皖AJ001Z";
		strcpy(entries[0].plateNos, plateNo);
		entries[0].plateNoBytes = strlen(plateNo);
		strcpy(entries[0].plateColor, "蓝");
		entries[0].plateColorBytes = strlen("蓝");
		append_blackwhite_list(device_ip, entries, 1);
	}

	if (argc == 3 && strcmp(cmd, "-remove_bwlist") == 0)
	{
		sBlackWhiteEntry entries[1];
		entries[0].type = 0;
		char * plateNo = "皖AJ001Z";
		strcpy(entries[0].plateNos, plateNo);
		entries[0].plateNoBytes = strlen(plateNo);
		strcpy(entries[0].plateColor, "蓝");
		entries[0].plateColorBytes = strlen("蓝");
		remove_blackwhite_list(device_ip, entries, 1);
	}

	if (argc == 3 && strcmp(cmd, "-clean_bwlist") == 0)
	{
		int type = 0;
		clean_blackwhite_list(device_ip, type);
	}

	if (argc == 3 && strcmp(cmd, "-query_bwlist") == 0)
	{
		int type = 0;
		sBlackWhiteEntry entries[100];
		int len;
		if (qurey_blackwhite_list(device_ip, type, entries, 100, &len) == API_STATUS::OK)
		{
			for (int i = 0; i < len; i++)
			{
				printf("BlackWhite Entry: %d %s %s %d %d \n",
						entries[i].type, entries[i].plateNos, entries[i].plateColor, entries[i].startTime, entries[i].endTime);
			}
		}
		else {
			printf("query blackwhite list with error");
		}
	}
}
