/*
 * lpr_comm.h
 *
 *  Created on: May 5, 2022
 *      Author: link
 */

#ifndef INCLUDE_LPR_COMM_H_
#define INCLUDE_LPR_COMM_H_

#include <string>

#define NO_EXCEPTION 	0
#define HAS_EXCEPTION 	1

#define __FILENAME__ (strrchr(__FILE__, '/') ? strrchr(__FILE__, '/') + 1 : __FILE__)

#define LPR_PRT_FUNC(fmt, ...) do { printf(" [%s]: ", __FUNCTION__);  printf(fmt);   }while(0)

#define LPR_PRT(fmt, ...) do {  printf(" [%s]-%d: ", __FILENAME__, __LINE__);  printf(fmt); }while(0)


#define LPR_PRT_INFO(fmt, ...) do {  printf("[Info]"); printf(fmt); printf("\n"); }while(0)

#define LPR_PRT_FATAL(fmt, ...)  do {  printf("[Fatal]"); printf(fmt);  printf("\n"); }while(0)

#define LPR_PRT_WARN(fmt, ...)   do { printf("[Warn]"); printf(fmt); printf("\n"); }while(0)

#define LPR_PRT_LINE(fmt, ...)   do { printf(" [%s]-%d: ", __FILENAME__, __LINE__); printf(fmt); printf("\n"); }while(0)
 
#endif /* INCLUDE_LPR_COMM_H_ */
