/******************************************************************************

  Copyright (C), 2016, Hisilicon Tech. Co., Ltd.

 ******************************************************************************
  File Name     : hi_comm_isp.h
  Version       : Initial Draft
  Author        : Hisilicon multimedia software group
  Created       : 2010/12/20
  Description   :
  History       :
  1.Date        : 2010/12/20
    Author      :
    Modification: Created file

******************************************************************************/

#ifndef __HI_COMM_ISP_H__
#define __HI_COMM_ISP_H__

#include "hi_type.h"


#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif /* End of #ifdef __cplusplus */

/* statistics structs */
#define HIST_NUM        (1024)
#define BAYER_PATTERN_NUM   (4)
#define WDR_CHN_MAX         (4)
#define ISP_CHN_MAX_NUM     (4)

/********************* AE structs ************************/
/*
Defines the AE mode
0 = Automatic frame rate reduction mode (slow shutter mode)
1 = Constant frame rate mode
*/
typedef enum hiISP_AE_MODE_E
{
    AE_MODE_SLOW_SHUTTER = 0,
    AE_MODE_FIX_FRAME_RATE  = 1,
    AE_MODE_BUTT
} ISP_AE_MODE_E;

/*
Defines the AE exposure policy mode
0 = Highlight first exposure mode
1 = Lowlight first exposure mode
*/
typedef enum hiISP_AE_STRATEGY_E
{
    AE_EXP_HIGHLIGHT_PRIOR = 0,
    AE_EXP_LOWLIGHT_PRIOR  = 1,
    AE_STRATEGY_MODE_BUTT
} ISP_AE_STRATEGY_E;


/*Defines the ISP exposure delay attribute*/
typedef struct hiISP_AE_DELAY_S
{
    HI_U16 u16BlackDelayFrame;    /*RW; Range:[0, 65535]; Format:16.0; AE black delay frame count*/
    HI_U16 u16WhiteDelayFrame;    /*RW; Range:[0, 65535]; Format:16.0; AE white delay frame count*/
} ISP_AE_DELAY_S;


/*Defines the maximum exposure time or gain and minimum exposure time or gain*/
typedef struct hiISP_AE_RANGE_S
{
    HI_U32 u32Max;  /*RW;Range:[0,0xFFFFFFFF];Format:32.0;Maximum value*/
    HI_U32 u32Min;  /*RW;Range:[0,0xFFFFFFFF];Format:32.0;limited Range:[0,u32Max],Minimum value*/
} ISP_AE_RANGE_S;


/*
Defines the anti-flicker mode.
0 = The epxosure time is fixed to be the multiplies of 1/(2*frequency) sec,it may lead to over exposure in the high-luminance environments.
1 = The anti flicker may be closed to avoid over exposure in the high-luminance environments.
*/
typedef enum hiISP_ANTIFLICKER_MODE_E
{
    ISP_ANTIFLICKER_NORMAL_MODE = 0x0,
    ISP_ANTIFLICKER_AUTO_MODE   = 0x1,
    ISP_ANTIFLICKER_MODE_BUTT
} ISP_ANTIFLICKER_MODE_E;

/*Defines the anti-flicker attribute*/
typedef struct hiISP_ANTIFLICKER_S
{
    HI_BOOL bEnable;              /*RW; Range:[0, 1]; Format:1.0;*/
    HI_U8   u8Frequency;          /*RW; Range:[0, 255]; Format:8.0; usually this value is 50 or 60  which is the frequency of the AC power supply*/
    ISP_ANTIFLICKER_MODE_E  enMode;
} ISP_ANTIFLICKER_S;

typedef struct hiISP_SUBFLICKER_S
{
    HI_BOOL bEnable; /*RW; Range:[0, 1]; Format:1.0; */

    HI_U8   u8LumaDiff;     /* RW; Range:[0, 100]; Format:8.0; if subflicker mode enable, current luma is less than AE compensation plus LumaDiff,
                                AE will keep min antiflicker shutter time(for example: 1/100s or 1/120s) to avoid flicker. while current luma is
                                larger than AE compensation plus the LumaDiff, AE will reduce shutter time to avoid over-exposure and introduce
                                flicker in the pircture */
} ISP_SUBFLICKER_S;

/*
Defines the ISP FSWDR operating mode
0 = Normal FSWDR mode
1 = Long frame mode, only effective in LINE_WDR, when running in this mode FSWDR module only output the long frame data
*/
typedef enum hiISP_FSWDR_MODE_E
{
    ISP_FSWDR_NORMAL_MODE          = 0x0,
    ISP_FSWDR_LONG_FRAME_MODE      = 0x1,
    ISP_FSWDR_AUTO_LONG_FRAME_MODE = 0x2,/*Auto long frame mode, only effective in LINE_WDR, When running in this mode, normal WDR and long frame mode would auto switch*/
    ISP_FSWDR_MODE_BUTT
} ISP_FSWDR_MODE_E;

typedef struct hiISP_AE_ATTR_S
{
    /* base parameter */
    ISP_AE_RANGE_S stExpTimeRange;   /*RW; Range:[0x0, 0xFFFFFFFF]; Format:32.0; sensor exposure time (unit: us ), it's related to the specific sensor */
    ISP_AE_RANGE_S stAGainRange;     /*RW; Range:[0x400, 0xFFFFFFFF]; Format:22.10; sensor analog gain (unit: times, 10bit precision), it's related to the specific sensor */
    ISP_AE_RANGE_S stDGainRange;     /*RW; Range:[0x400, 0xFFFFFFFF]; Format:22.10;  sensor digital gain (unit: times, 10bit precision), it's related to the specific sensor */
    ISP_AE_RANGE_S stISPDGainRange;  /*RW; Range:[0x400, 0x40000]; Format:22.10;  ISP digital gain (unit: times, 10bit precision), it's related to the ISP digital gain range */
    ISP_AE_RANGE_S stSysGainRange;   /*RW; Range:[0x400, 0xFFFFFFFF]; Format:22.10;  system gain (unit: times, 10bit precision), it's related to the specific sensor and ISP Dgain range */
    HI_U32 u32GainThreshold;         /*RW; Range:[0x400, 0xFFFFFFFF]; Format:22.10;  Gain threshold for slow shutter mode (unit: times, 10bit precision)*/

    HI_U8  u8Speed;                  /*RW; Range:[0x0, 0xFF]; Format:8.0; AE adjust step for dark scene to bright scene switch */
    HI_U16  u16BlackSpeedBias;       /*RW; Range:[0x0, 0xFFFF]; Format:16.0; AE adjust step bias for bright scene to dark scene switch */
    HI_U8  u8Tolerance;              /*RW; Range:[0x0, 0xFF]; Format:8.0; AE adjust tolerance*/
    HI_U8  u8Compensation;           /*RW; Range:[0x0, 0xFF]; Format:8.0; AE compensation*/
    HI_U16  u16EVBias;               /*RW; Range:[0x0, 0xFFFF]; Format:16.0; AE EV bias*/
    ISP_AE_STRATEGY_E enAEStrategyMode;  /*RW; Range:[0, 1]; Format:1.0; Support Highlight prior or Lowlight prior*/
    HI_U16  u16HistRatioSlope;       /*RW; Range:[0x0, 0xFFFF]; Format:16.0; AE hist ratio slope*/
    HI_U8   u8MaxHistOffset;         /*RW; Range:[0x0, 0xFF]; Format:8.0; Max hist offset*/

    ISP_AE_MODE_E  enAEMode;         /*RW; Range:[0, 1]; Format:1.0; AE mode(slow shutter/fix framerate)(onvif)*/
    ISP_ANTIFLICKER_S stAntiflicker;
    ISP_SUBFLICKER_S stSubflicker;
    ISP_AE_DELAY_S stAEDelayAttr;

    HI_BOOL bManualExpValue;         /*RW; Range:[0, 1]; Format:1.0; manual exposure value or not*/
    HI_U32 u32ExpValue;              /*RW; Range:(0x0, 0xFFFFFFFF]; Format:32.0; manual exposure value */

    ISP_FSWDR_MODE_E enFSWDRMode;    /*RW; Range:[0, 2]; Format:2.0; FSWDR running mode */
    HI_BOOL bWDRQuick;               /*RW; Range:[0, 1]; Format:1.0; WDR use delay strategy or not; If is true, WDR AE adjust will be faster */

    HI_U16  u16ISOCalCoef;     /*RW; Range:[0x0, 0xFFFF]; Format:8.8; The coefficient between Standard ISO and origin ISO (unit: times, 8bit precision)*/
} ISP_AE_ATTR_S;

/*
Defines the working mode of ISP
0 = automatic mode
1 = manual mode
*/
typedef enum hiISP_OP_TYPE_E
{
    OP_TYPE_AUTO    = 0,
    OP_TYPE_MANUAL  = 1,
    OP_TYPE_BUTT
} ISP_OP_TYPE_E;


typedef struct hiISP_ME_ATTR_S
{
    ISP_OP_TYPE_E enExpTimeOpType;
    ISP_OP_TYPE_E enAGainOpType;
    ISP_OP_TYPE_E enDGainOpType;
    ISP_OP_TYPE_E enISPDGainOpType;

    HI_U32 u32ExpTime;        /*RW; Range:[0x0, 0xFFFFFFFF]; Format:32.0; sensor exposure time (unit: us ), it's related to the specific sensor */
    HI_U32 u32AGain;          /*RW; Range:[0x400, 0xFFFFFFFF]; Format:22.10; sensor analog gain (unit: times, 10bit precision), it's related to the specific sensor */
    HI_U32 u32DGain;          /*RW; Range:[0x400, 0xFFFFFFFF]; Format:22.10; sensor digital gain (unit: times, 10bit precision), it's related to the specific sensor */
    HI_U32 u32ISPDGain;       /*RW; Range:[0x400, 0x40000]; Format:22.10; ISP digital gain (unit: times, 10bit precision), it's related to the ISP digital gain range */
} ISP_ME_ATTR_S;

typedef struct hiISP_EXPOSURE_ATTR_S
{
    HI_BOOL         bByPass;    /*RW; Range:[0, 1]; Format:1.0; */
    ISP_OP_TYPE_E   enOpType;
    HI_U8     u8AERunInterval;  /*RW; Range:[0x1, 0xFF]; Format:8.0; set the AE run interval*/
    HI_BOOL   bHistStatAdjust;  /*RW; Range:[0, 1]; Format:1.0;  HI_TRUE: 256 bin histogram statistic config will adjust when large red or blue area detected.
                                                        HI_FALSE: 256 bin histogram statistic config will not change */
    HI_BOOL   bAERouteExValid;  /*RW; Range:[0, 1]; Format:1.0; use extend AE route or not */
    ISP_ME_ATTR_S   stManual;
    ISP_AE_ATTR_S   stAuto;
} ISP_EXPOSURE_ATTR_S;

/*
Defines the F value of the ISP iris
*/
typedef enum hiISP_IRIS_F_NO_E
{
    ISP_IRIS_F_NO_32_0 = 0,
    ISP_IRIS_F_NO_22_0,
    ISP_IRIS_F_NO_16_0,
    ISP_IRIS_F_NO_11_0,
    ISP_IRIS_F_NO_8_0,
    ISP_IRIS_F_NO_5_6,
    ISP_IRIS_F_NO_4_0,
    ISP_IRIS_F_NO_2_8,
    ISP_IRIS_F_NO_2_0,
    ISP_IRIS_F_NO_1_4,
    ISP_IRIS_F_NO_1_0,

    ISP_IRIS_F_NO_BUTT,
} ISP_IRIS_F_NO_E;

#define ISP_AE_ROUTE_MAX_NODES (16)
typedef struct hiISP_AE_ROUTE_NODE_S
{
    HI_U32  u32IntTime;          /*RW; Range:(0x0, 0xFFFFFFFF]; Format:32.0; sensor exposure time (unit: us ), it's related to the specific sensor */
    HI_U32  u32SysGain;          /*RW; Range:[0x400, 0xFFFFFFFF]; Format:22.10; system gain (unit: times, 10bit precision), it's related to the specific sensor and ISP Dgain range */
    ISP_IRIS_F_NO_E  enIrisFNO;  /*RW; Range:[0, 10]; Format:4.0; the F number of the iris's aperture, only support for Piris */
    HI_U32  u32IrisFNOLin;       /*RW; Range:[0x1, 0x400]; Format:32.0; the equivalent gain of F number of the iris's aperture, only support for Piris */
} ISP_AE_ROUTE_NODE_S;

typedef struct hiISP_AE_ROUTE_EX_NODE_S
{
    HI_U32  u32IntTime;     /*RW; Range:(0x0, 0xFFFFFFFF]; Format:32.0;  sensor exposure time (unit: us ), it's related to the specific sensor */
    HI_U32  u32Again;       /*RW; Range:[0x400, 0x3FFFFF]; Format:22.10;  sensor analog gain (unit: times, 10bit precision), it's related to the specific sensor*/
    HI_U32  u32Dgain;       /*RW; Range:[0x400, 0x3FFFFF]; Format:22.10;  sensor digital gain (unit: times, 10bit precision), it's related to the specific sensor*/
    HI_U32  u32IspDgain;    /*RW; Range:[0x400, 0x40000]; Format:22.10;  ISP digital gain (unit: times, 10bit precision)*/
    ISP_IRIS_F_NO_E  enIrisFNO;  /*RW; Range:[0, 10]; Format:4.0; the F number of the iris's aperture, only support for Piris */
    HI_U32  u32IrisFNOLin;  /*RW; Range:[0x1, 0x400]; Format:32.0; the equivalent gain of F number of the iris's aperture, only support for Piris */
} ISP_AE_ROUTE_EX_NODE_S;

#define ISP_AE_ROUTE_EX_MAX_NODES (16)
typedef struct hiISP_AE_ROUTE_EX_S
{
    HI_U32 u32TotalNum;       /*RW; Range:[0, 0x10]; Format:8.0; total node number of extend AE route */
    ISP_AE_ROUTE_EX_NODE_S astRouteExNode[ISP_AE_ROUTE_EX_MAX_NODES];
} ISP_AE_ROUTE_EX_S;


typedef struct hiISP_AE_ROUTE_S
{
    HI_U32 u32TotalNum;     /*RW; Range:[0, 0x10]; Format:8.0; total node number of AE route */
    ISP_AE_ROUTE_NODE_S astRouteNode[ISP_AE_ROUTE_MAX_NODES];
} ISP_AE_ROUTE_S;

typedef struct hiISP_EXP_INFO_S
{
    HI_U32 u32ExpTime;                 /*R; Range:[0x0, 0xFFFFFFFF]; Format:32.0;*/
    HI_U32 u32ShortExpTime;            /*R; Range:[0x0, 0xFFFFFFFF]; Format:32.0;*/
    HI_U32 u32MedianExpTime;           /*R; Range:[0x0, 0xFFFFFFFF]; Format:32.0;*/
    HI_U32 u32LongExpTime;             /*R; Range:[0x0, 0xFFFFFFFF]; Format:32.0;*/
    HI_U32 u32AGain;                   /*R; Range:[0x400, 0xFFFFFFFF]; Format:22.10;*/
    HI_U32 u32DGain;                   /*R; Range:[0x400, 0xFFFFFFFF]; Format:22.10;*/
    HI_U32 u32ISPDGain;                /*R; Range:[0x400, 0xFFFFFFFF]; Format:22.10;*/
    HI_U32 u32Exposure;                /*R; Range:[0x40, 0xFFFFFFFF]; Format:26.6;*/
    HI_BOOL bExposureIsMAX;            /*R; Range:[0, 1]; Format:1.0;*/
    HI_S16 s16HistError;               /*R; Range:[-32768, 32767]; Format:16.0;*/
    HI_U32 au32AE_Hist1024Value[HIST_NUM]; /*R; Range:[0x0, 0xFFFFFFFF]; Format:32.0; 1024 bins histogram for channel 1 */

    HI_U8  u8AveLum;                   /*R; Range:[0x0, 0xFF]; Format:8.0;*/
    HI_U32 u32LinesPer500ms;           /*R; Range:[0x0, 0xFFFFFFFF]; Format:32.0; exposure lines per 500ms */
    HI_U32 u32PirisFNO;                /*R; Range:[0x0, 0x400]; Format:32.0;*/
    HI_U32 u32Fps;                     /*R; Range:[0x0, 0xFFFFFFFF]; Format:32.0; actual fps */
    HI_U32 u32ISO;                     /*R; Range:[0x64, 0xFFFFFFFF]; Format:32.0;*/
    HI_U32 u32ISOCalibrate;            /*R; Range:[0x0, 0xFFFFFFFF]; Format:32.0;*/
    HI_U32 u32RefExpRatio;             /*R; Range:[0x40, 0x4000]; Format:26.6;*/
    HI_U32 u32FirstStableTime;         /*R; Range:[0x0, 0xFFFFFFFF]; Format:32.0; AE first stable time for quick start */
    ISP_AE_ROUTE_S stAERoute;          /*R; Actual AE route */
    ISP_AE_ROUTE_EX_S stAERouteEx;     /*R; Actual AE route_ex */
} ISP_EXP_INFO_S;


#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* End of #ifdef __cplusplus */

#endif /* __HI_COMM_ISP_H__ */
