/*
 * demo.cpp
 * 
 *  all right reserved by Xinhuan Intelligence co., ltd
 *  contact us at https://github.com/lqian/light-lpr
 *
 */
#include <thread>
#include <iostream>
#include <fstream>
#include <sstream>
#include <stdio.h>
#include <stdlib.h>
#include <chrono>
#include <time.h>

#include "lpr_comm.h"
#include "dev_client_api.h"

using namespace std;

// #define use_cert_key

/**
 * @brief callback of camera event
 *        相机事件回调
 * @param ip camera ip
 * @param code envet code, 0 represents the camera is online, other values represent the camera occurs exception
 * 		  事件代码，0表示相机在线，其他非零值，表示相机有异常
 * @param msg message of event
 */
void demo_camera_event_callback_func(const char *ip, int code, const char * msg)
{
	printf("camera: %s event code: %d with message: %s \n", ip, code, msg);
}

void demo_callback_func(PlateBasicInfo * pbi) {
	string plateNo(pbi->plateNos, pbi->plateNoBytes);
	printf("%16s plate no: %s at [%f, %f, %f, %f] with confidence: %f, plate type: %d \n",
			pbi->deviceIP,
			plateNo.c_str(),
			pbi->bbox.xmin, pbi->bbox.ymin, pbi->bbox.xmax, pbi->bbox.ymax,
			pbi->prob, pbi->plateType);

	if (pbi->parkingSpotStatus > -1)
	{
		printf("parking spot status: %d at anchor box: %d\n", pbi->parkingSpotStatus, pbi->anchorBoxNo);
	}

	if (pbi->imageBuffer == NULL ) return;

	time_t curr=time(NULL);
	stringstream ss;
	ss << curr << ".jpg";
	//save image to file
	ofstream out(ss.str().c_str(), ios_base::binary);
	if (out.is_open()) {
		out.write(pbi->imageBuffer, pbi->imageBufferSize);
		out.flush();
		out.close();
		cout << "save file success!" << endl;
	}
	else {
		cout << "open file error!" << endl;
	}
}

int main(int argc, char ** argv)
{
	if (argc < 3)
	{
		printf("usage: DEMO [local_ip] [local_port] [device ip]...\n"
				"example: DEMO 192.168.1.102 20790 192.168.1.20 192.168.1.201 \n");
		exit(1);
	}
	char * local_ip = argv[1];
	int local_port = atoi(argv[2]);
	int ret = init_client(local_ip, local_port, demo_callback_func);
	reg_camera_event_callback(demo_camera_event_callback_func);
#ifdef use_cert_key	
	char * key = "abcdef0123456789";
	set_cert_key(key, 16);
#endif

	if (ret  != NO_EXCEPTION)
	{
		printf("init client api failed!\n");
		exit(1);
	}

	for (int i = 3; i < argc; i++) {
		if (connect_device(argv[i]) == API_STATUS::OK) {
			printf("connect device success: %s \n", argv[i]);
		}
		else {
			printf("connect device failed: %s \n", argv[i]);
		}
	}
	printf("--------------- devices connected ------------\n");
	printf("press key q for quit!");
	char k = '\0';
	while ((k = getchar()) != 'q')
	{
		if (k == 's' && argc >= 4) {
			char * ip = argv[3];
			if (take_snapshot_tofile(ip, "snap.jpg") == NO_EXCEPTION)
			{
				printf("snapshot to file ok!\n");
			}
		}
		if (k == 't' && argc >=4)
		{
			char * ip = argv[3];
			char * buff = NULL;
			int len = 0;
			if (take_snapshot_sync(ip, &buff, &len) == NO_EXCEPTION)
			{
				printf("snapshot ok with %d bytes!\n", len);
			}

			if (buff != NULL)
			{
				free(buff);
			}
		}
		std::this_thread::sleep_for(std::chrono::seconds(1));	
	}

	close_client();  // the function can call in another thread

	exit(0);
}
