﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Threading;
using System.Data;
using System.Runtime.InteropServices;

namespace Demo
{
    class Program
    {
        static void Main(string[] args)
        {
            // 发送一些指令
            string deviceIP = "192.168.1.21"; 
            if (args.Length > 0)
            {
                deviceIP = args[0];
            }

            API_STATUS ret;

            // 增加黑白名单

            BlackWhiteEntry[] blackWhiteEntries = fillBWList();
            ret = LLPRAPI.appendBlackwhiteList(deviceIP, blackWhiteEntries, 2);
            if (ret == API_STATUS.OK)
            {
                Console.WriteLine("appendBlackwhiteList success");
            }
            else
            {
                Console.WriteLine("appendBlackwhiteList failure with code: {}", ret);
            }

            // 以callack形式查询黑白名单     
            LLPRAPI.BlackWhiteListCallback bwcb = new LLPRAPI.BlackWhiteListCallback(bwlistCallback);
            ret = LLPRAPI.queryBlackwhiteListCallback(deviceIP, 0, bwlistCallback);

            // 清除黑名单
            ret = LLPRAPI.cleanBlackwhiteList(deviceIP, 0);

            // 串口透传
            ret = LLPRAPI.writeUart(deviceIP, "485-1", "aaaaaa aaaa", 11);

            // 触发报警线路1
            ret = LLPRAPI.triggerAlarmout(deviceIP, 0, 1000);

            //查询报警线路1状态
            int status = -1;
            ret = LLPRAPI.queryAlarm(deviceIP, 0, ref status);
            if (ret == API_STATUS.OK)
            {
                Console.WriteLine("alarm out status is: {0}", status);
            }
            else
            {
                Console.WriteLine("alarm out failure code: {0}", status);
            }

            // 启动接收图片和相机事件的代码片段
            LLPRAPI.Callback cb = new LLPRAPI.Callback(demoCallback);
            // 把192.168.1.77换成运行机器的IP
            if (LLPRAPI.initClientApi("192.168.1.77", 20790, cb) != API_STATUS.OK)
            {
                Console.WriteLine("initialize API failure!");
                return;
            }
            else
            {
                Console.WriteLine("initialize API success!");
            }

            LLPRAPI.regCameraEventCallback(new LLPRAPI.CameraEventCallback(cameraEventCallBack));

            Console.WriteLine(args.Length);
            if (args.Length > 0)
            {
                for (int i = 0; i < args.Length; i++)
                    if (LLPRAPI.connectDevice(args[i]) == API_STATUS.OK)
                    {
                        Console.WriteLine("connect device success: {0}!", args[i]);  
                    }
                    else
                    {
                        Console.WriteLine("connect device failure!");
                        return;
                    } 
            }
            else
            {
                if (LLPRAPI.connectDevice(deviceIP) != API_STATUS.OK)
                {
                    Console.WriteLine("connect device failure!");
                    return;
                } 
            }

            // 如果相机设置密钥，需要为API设置解密的密码，否则对接程序需要自行解密，本Demo默认相机未设置密钥
            // setCertKey("abcdef0123456789", 16);

            // 触发相机抓拍，抓拍图片保存到相机, 且发送给车牌回调
            LLPRAPI.takeSnapshot(deviceIP);

            // 触发相机抓拍，抓拍图片保存到相机，且保存到本地图片，不发送给车牌回调
            LLPRAPI.takeSnapshotToFile(deviceIP, "snap_file.jpg", 30);
            

            Thread.Sleep(3000 * 1000);
            // can close api in another thread
            Console.WriteLine("prepare to exit...");
            LLPRAPI.closeClientApi();
        }

        public static void bwlistCallback(ref BlackWhiteEntry entry)
        {
            Console.WriteLine("entry type: {0} plateNo: {1}, plateColor: {2}, starttime: {3}, endtime: {4}",
             entry.type, entry.plateNos, entry.plateColor, entry.startTime, entry.endTime);
        }

        public static void cameraEventCallBack(string ip, int code, string msg)
        {
            Console.WriteLine("camera ip: " + ip, " code:" + code + " with msg:" + msg);
        }

        public static void demoCallback(ref PlateBasicInfo pbi)
        {
            Console.WriteLine("plate No: {0} {1} at [{2}, {3}, {4}, {5}], {6}, image size: {7} from: {8}",
                pbi.plateNos, pbi.plateColor, pbi.bbox.xmin, pbi.bbox.ymin, pbi.bbox.xmax, pbi.bbox.ymax, pbi.plateNoBytes,
                pbi.imageBufferSize, pbi.deviceIP);
            if (pbi.imageBufferSize == 0)
            {
                return;
            }

            BinaryWriter writer = new BinaryWriter(new FileStream("test.jpg", FileMode.Create));
            byte[] buffer = new byte[pbi.imageBufferSize];
            System.Runtime.InteropServices.Marshal.Copy(pbi.imageBuffer, buffer, 0, pbi.imageBufferSize);
            writer.Write(buffer);
            writer.Close();
            Console.WriteLine("write plate image success!");
        }


        static BlackWhiteEntry[] fillBWList()
        {
            BlackWhiteEntry[] blackWhiteEntries = new BlackWhiteEntry[2];
            blackWhiteEntries[0].type = 0;
            // 相机内部是以UTF8编码进行工作的，如果是GBK或者其他编码，需要先转换成UTF8编码
            // 本段示例代码向相机增加一个黑名单一个白名单
            byte[] plateNoBuff = Encoding.UTF8.GetBytes("皖AJ001Z");
            blackWhiteEntries[0].plateNos_ = new byte[64];  // 须先预分配内存再copy
            blackWhiteEntries[0].plateNoBytes = plateNoBuff.Length;
            Array.Copy(plateNoBuff, blackWhiteEntries[0].plateNos_, plateNoBuff.Length);

            byte[] plateColorBuff = Encoding.UTF8.GetBytes("蓝");
            blackWhiteEntries[0].plateColorBytes = plateColorBuff.Length;
            blackWhiteEntries[0].plateColor_ = new byte[16];
            Array.Copy(plateColorBuff, blackWhiteEntries[0].plateColor_, plateColorBuff.Length);
            blackWhiteEntries[0].startTime = -1;
            blackWhiteEntries[0].endTime = -1;

            blackWhiteEntries[1].type = 1;
            plateNoBuff = Encoding.UTF8.GetBytes("皖A102GU");
            blackWhiteEntries[1].plateNos_ = new byte[64];
            blackWhiteEntries[1].plateNoBytes = plateNoBuff.Length;
            Array.Copy(plateNoBuff, blackWhiteEntries[1].plateNos_, plateNoBuff.Length);

            blackWhiteEntries[1].plateColor_ = new byte[16];
            Array.Copy(plateColorBuff, blackWhiteEntries[1].plateColor_, plateColorBuff.Length);
            blackWhiteEntries[1].plateColorBytes = plateColorBuff.Length;

            int startTime = (int)(DateTime.UtcNow - new DateTime(1970, 1, 1, 0, 0, 0, 0)).TotalSeconds;
            int endTime = (int)(DateTime.UtcNow.AddMonths(1) - new DateTime(1970, 1, 1, 0, 0, 0, 0)).TotalSeconds;
            blackWhiteEntries[1].startTime = startTime;
            blackWhiteEntries[1].endTime = endTime;

            return blackWhiteEntries;
        }
    }   
}
