package com.xinhuan.lightlpr.demo;

import androidx.appcompat.app.AppCompatActivity;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import static com.xinhuan.lightlpr.api.LLPR.*;

import com.xinhuan.lightlpr.api.LLPR;
import com.xinhuan.lightlpr.api.PlateBasicInfo;
import com.xinhuan.lightlpr.api.PlateBox;


import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class MainActivity extends AppCompatActivity implements LLPR.Callback {

    File dir;
    Context context;
    PlateBasicInfo plateBasicInfo;

    Handler mHandler = new Handler();

    public void onRecogPlate(PlateBasicInfo pbi) {
        plateBasicInfo = pbi;

        // MUST UPDATE VIEWS IN ANOTHER THREAD
        mHandler.post(new Runnable() {
            @Override
            public void run() {
                TextView tv4 = findViewById(R.id.textView4);
                tv4.setText("" + plateBasicInfo.plateNos);
                TextView tv5 = findViewById(R.id.textView5);
                tv5.setText("" + plateBasicInfo.plateColor);
                TextView tv6 = findViewById(R.id.textView6);
                tv6.setText("" + plateBasicInfo.prob);
                TextView tv7 = findViewById(R.id.textView7);
                tv7.setText("" + plateBasicInfo.imageBufferSize);
            }
        });


        PlateBox bb = plateBasicInfo.plateBox;
        Log.i("light-lpr-api", String.format("%s at (%f, %f, %f, %f) with prob: %f, image size: %d",
                plateBasicInfo.plateNos,
                bb.xmin, bb.ymin, bb.xmax, bb.ymax,
                plateBasicInfo.prob, plateBasicInfo.imageBufferSize));

        try {
            File file = new File(dir, "test.jpg");
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(pbi.imageBuffer, 0, plateBasicInfo.imageBufferSize);
            fos.close();
        }
        catch (IOException e) {
            Log.e("light-lpr-api", e.getMessage());
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);


        context = getApplicationContext();
        // get current image dir
        dir = context.getExternalFilesDir("xinhuan");

        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                Toast.makeText(this, "权限不足", Toast.LENGTH_LONG).show();
            }
        }

        regCallback(MainActivity.class.getName(), this);
        Log.i("light-lpr-api", MainActivity.class.getName());

        final EditText tvDeviceIP = findViewById(R.id.editText_deviceip);
        final EditText tvLocalIP = findViewById(R.id.editText_localip);
        final EditText tvLocalPort = findViewById(R.id.editText_localport);

        final TextView tvStatus = findViewById(R.id.textView_status);
        Button connect = findViewById(R.id.button_connect);


        connect.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
                int status = initClientApi2(tvDeviceIP.getText().toString(),
                        tvLocalIP.getText().toString(),
                        Integer.parseInt(tvLocalPort.getText().toString()));
                if (status == 0) {
                    tvStatus.setText("success");
                } else {
                    tvStatus.setText("failed");
                }
            }
        });

        Button close = findViewById(R.id.button_close);
        close.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                closeClientApi();
                tvStatus.setText("");
            }
        });
    }
}
