## light-lpr-api 对接说明

light-lpr-api是针对昕桓智能LLPR全系列相机通用的对接开发包。主要针对使用c、c++、c#的语言编程对接场合。目前支持win-32/64、linux-32/64平台。以包的目录结构如下，windows系列开发包目录结构相同

```
.
├── DEMO      
├── lib
│   ├── liblight-lpr-api-linux64.so -> liblight-lpr-api-linux64.so.4.7.5.40596
│   ├── liblight-lpr-api-linux64.so.4.7.5.40596 
├── MGT_DEMO
└── samples
    ├── android
    ├── c#
    └── c++
├── third_party    
```

其中demo是接收车牌信息和抓拍图片的可执行示例程序；mgt_demo是向相机发送指令的示例程序。

lib目录下包含了light-lpr-api库运行时需要的动态库

samples目录下包含了andriod，c#，c++开放对接的示例代码。

third_party目录包含了运行期需要的第三方库

### 快速运行和验证

库的当前目录下启动命令窗口运行

```
> set PATH=lib;third_party;%PATH%
> .\DEMO 192.168.1.77 20790 192.168.1.21 192.168.1.22

[Info]bind success
[Info]set socket opt success
connect device success: 192.168.1.21
connect device success: 192.168.1.22
--------------- devices connected ------------
press key q for quit!
```

如果是linux平台，快速启动命令如下

```
$ export PATH=lib:third_party:$PATH
$ ./DEMO 192.168.1.77 20790 192.168.1.21 192.168.1.22
```

其中，192.168.1.77是运行本机机器的地址，20790是API启动的监听端口，10000以上的端口均可以，192.168.1.21和192.168.1.22是相机的IP地址，一次可以指定多个，空格分隔。

运行成功后，拿车牌对着相机，相机会把识别结果推送到API端，打印的信息如下。

```
   192.168.1.216 plate no: 皖A102GU at [734.359131, 446.916931, 953.947754, 519.240356] with confidence: 0.784997, plate type: 30
parking spot status: 22 at anchor box: 0
save file success!
```

### 快速发送指令给相机

以向IP为192.168.1.21的相机的485-1串口透传数据为例

```
> .\MGT_DEMO -write_uart 192.168.1.21 485-1 aaaaaaaaaaa
```

在相机日志中应该能看到如下的行

```
10341 2023-11-17 22:19:53 485-1 WRITE aaaaaaaaaaa BYTES: 11
```

### 基本运行机制

这里,LLPR车牌识别相机简称为设备,设备和客户端通过TCP/IP进行通讯。客户端的API在初始化时，启动一个接收车牌信息的监听服务。然后连接设备，当设备识别到车牌时，发送给监听服务。监听服务调用callback以实现信息的对接。

相机上线，掉线时，会发送通知给客户端。

***注：由于callback是运行监听的线程内部，所以在callback内部不能再向相机发起其他的指令，比如报警输出开闸，抓拍，485透传等。***

为了高效的接收信息，callback内部也不建议实现复杂的业务逻辑，能满足保存信息和图片即可。

```sequence
Title: 运行示意图
客户端->客户端: 初始化客户端，启动监听
客户端->客户端: 注册相机事件回调
客户端->相机: 连接相机
相机-->客户端: 推送上线/下线事件
相机-->客户端: 推送车牌号码和图片
客户端->客户端: 关闭
管理端->相机: 抓拍/开闸/485透传等管理指令


```

如果对接设置过密钥的相机，可以在API对接是设置密钥，让API对已加密的信息进行解密。也可以不设置解密的密钥，对接的系统自行解密。

### API简介和支持列表

| 函数名称                       | 说明                                           | c++支持 | c#适配                      |
| ------------------------------ | ---------------------------------------------- | ------- | --------------------------- |
| init_client                    | 初始化客户端                                   | Y       | initClientApi               |
| reg_camera_event_callback      | 注册相机上线下线事件回调                       | Y       | regCameraEventCallback      |
| connect_device                 | 连接相机                                       | Y       | connectDevice               |
| close_client                   | 关闭客户端,断开所有的相机连接                  | Y       | closeClientApi              |
| reboot_device                  | 重启一个相机                                   | Y       | rebootDevice                |
| set_time                       | 给设置相机时间，时间参数要求为unix标准的时间戳 | Y       | setTime                     |
| trigger_alarmout               | 触发报警线路                                   | Y       | triggerAlarmout             |
| query_alarm                    | 查询相机的某一路报警线路的状态。               | Y       | queryAlarm                  |
| write_uart                     | 串口透传                                       | Y       | writeUart                   |
| take_snapshot                  | 发送抓拍指令                                   | Y       | takeSnapshot                |
| take_snapshot_sync             | 发送抓拍指令，并等待返回结果                   | Y       | takeSnapshotSync            |
| take_snapshot_tofile           | 发送抓拍指令，等待图片写入到文件               | Y       | takeSnapshotToFile          |
| qurey_blackwhitelist           | 查询黑白名单                                   | Y       |                             |
| query_blackwhite_list_callback | 回调方式查询黑白名单                           |         | queryBlackwhiteListCallback |
| append_blackwhite_list         | 追加黑白名单                                   | Y       | appendBlackwhiteList        |
| remove_blackwhite_list         | 删除黑白名单                                   | Y       | removeBlackwhiteList        |
| clean_blackwhite_list          | 清除所有黑白名单                               | Y       | cleanBlackwhiteList         |
| get_device_info                | 获取设备信息                                   | Y       | getDeviceInfo               |
| setup_camera_cert_key          | 初始化相机的密钥                               | Y       | setCameraCertKey            |
| set_cert_key                   | 设置api运行期解密的key                         | Y       | setCertKey                  |

函数详细说明请参考API发现包中的sample/c++/dev_client_api.h文件。

### 主要结构体介绍

#### PlateBasicInfo 

用于接收车牌信息和图片

| 字段名            | C类型     | 说明                                                         | c++支持 | c#适配                      |
| ----------------- | --------- | ------------------------------------------------------------ | ------- | --------------------------- |
| label             | int       | 保留                                                         | Y       | label                       |
| prob              | float     | 置信度                                                       | Y       | prob                        |
| bbox              | PlateBox  | 车牌位置                                                     | y       | bbox                        |
| confidences       | float[12] | 车牌号码单字置信度数组                                       | y       | confidences                 |
| len               | int       | 车牌号码单字置信度数组长度                                   | y       | len                         |
| plateNos          | char[64]  | UTF8变长码编码的车牌号码。                                   | y       |                             |
| plateNoBytes      | int       | 车牌号码实际实际长度，不超过MAX_PLATE_NO_BYTES变量定义       | y       | plateNos和plateNoBytes合并  |
| plateColor        | char[16]  | 车牌颜色 UTF8变长码 白  黄  蓝  黑   黄绿 绿                 | y       |                             |
| plateColorBytes   | int       | 车牌颜色字节数                                               | y       |                             |
| anchorBoxNo       | int       | 识别框编号，取值-1, 0, 1, 2,...，-1表示不支持此属性或者没有输出此属性 | y       | anchorBoxNo                 |
| plateType         | int       | 中国大陆车牌类型，定义如下<br/> 0 {未知}<br/>10 - 16  {军 双层军牌 武警 双层武警牌 警 应急 新电动车}<br/>20 - 23 {黄 教练车牌 双层黄牌 挂车车牌}<br/>30 {蓝色小汽车}<br/>40 - 43 {使馆牌 领馆牌 粤港澳牌 黑色小汽车 }<br/>50 {大型双能源}<br/>60 - 63  {新能源 民航  农用车牌 电动车牌（非机动）} | Y       | plateType                   |
| deviceIP          | char[15]  | 相机IP地址                                                   | y       |                             |
| deviceIPbytes     | int       | 相机IP地址的所占用的长度                                     | y       | deviceIP和deviceIPbytes合并 |
| direction         | int       | 方向标志 -1 未定义 0 从上到下 1 从下到上                     | y       | direction                   |
| parkingSpotStatus | int       | 车辆事件状态；对于不同系列有不同的定义<br/> 对低位视频桩、新能源车位管理相机、高位视频桩产品定义如下：<br> 0 空场 1 进场 2 停稳 3 出场 <br/> 21 抓拍（通用）<br/>E5系列定义的状态如下<br/> 22 入场 23 倒车 24 机动车滞留 25 非机动车滞留 26 行人滞留<br/> 27 无牌车 28 跟车 | y       | parkingSpotStatus           |
| plateFlag         | int       | 车牌真伪标志 -1 未定义 0 假 1 真                             | y       | plateFlag                   |
| headTailFlag      | int       | 车头车尾标志 -1 未定义 0 车头 1 车尾                         | y       | headTailFlag                |
| triggerMode       | int       | 触发模式，E5系列有效<br/> -1 未定义 0 相机视频触发 1 线圈触发 2 输入线路1 3 输入线路2 ... | y       | triggerMode                 |
| imageBufferSize   | int       | 图片buffer长度                                               | y       | imageBufferSize             |
| imageBuffer       | char *    | 图片Buffer, JPEG格式                                         | y       | imageBuffer                 |



### 视频播放

标准的rtsp流播放地址，rtsp://admin:123456@192.168.1.21/lightlpr/live/video。目前light-lpr-api没有提供播放RTSP流的实现。

### 

